/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.data.impl;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Util {
    public static final String JDBC_CLASS = "org.hsqldb.jdbcDriver";
    public static final String URL_CONEXION = "jdbc:hsqldb:file:";
    public static final String[] ARCHIVOS_DATA = new String[]{"bdd_dimm_anexos.properties", "bdd_dimm_anexos.script"};
    public static final String CONF_EHCACHE = "rig-catalogos-ehcache.xml";
    private static final String CARPETA_DATOS = ".dimmData";

    private Util() {
    }

    public static String obtenerRutaBDD() {
        String rutaCompleta = null;
        StringBuffer rutaBaseDatos = new StringBuffer(32);
        rutaBaseDatos.append(File.separator).append(CARPETA_DATOS).append(File.separator).append("BD_DIMM").append(File.separator).append("bdd_dimm_anexos");
        String userHome = System.getProperty("user.home");
        rutaCompleta = String.valueOf(userHome) + rutaBaseDatos.toString();
        return rutaCompleta;
    }

    public static void crearDirData() {
        String dir1 = String.valueOf(File.separator) + CARPETA_DATOS;
        String dir2 = String.valueOf(File.separator) + "BD_DIMM";
        String dir3 = String.valueOf(File.separator) + "ehcache";
        String userHome = System.getProperty("user.home");
        StringBuffer rutaCompleta = new StringBuffer(userHome).append(dir1);
        File folder = new File(rutaCompleta.toString());
        if (!folder.exists()) {
            folder.mkdir();
        }
        rutaCompleta.append(dir2);
        folder = new File(rutaCompleta.toString());
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder = new File((rutaCompleta = new StringBuffer(userHome).append(dir1).append(dir3)).toString())).exists()) {
            folder.mkdir();
        }
    }

    public static void copiarArchivosData() {
        String rutaOrigen = "/resources/";
        String dir = String.valueOf(File.separator) + CARPETA_DATOS + File.separator + "BD_DIMM";
        String userHome = System.getProperty("user.home");
        String rutaDestino = String.valueOf(userHome) + dir;
        try {
            InputStream is = null;
            String[] stringArray = ARCHIVOS_DATA;
            int n = ARCHIVOS_DATA.length;
            int n2 = 0;
            while (n2 < n) {
                String archivo = stringArray[n2];
                String rutaOrigenTemp = String.valueOf(rutaOrigen) + archivo;
                is = Util.loadStream(rutaOrigenTemp);
                Util.copiarArchivos(is, new File(rutaDestino, archivo));
                ++n2;
            }
            dir = String.valueOf(File.separator) + CARPETA_DATOS + File.separator + "ehcache";
            rutaDestino = String.valueOf(userHome) + dir;
            String rutaOrigenTemp = String.valueOf(rutaOrigen) + CONF_EHCACHE;
            is = Util.loadStream(rutaOrigenTemp);
            Util.copiarArchivos(is, new File(rutaDestino, CONF_EHCACHE));
        }
        catch (IOException e) {
            PluginLogger.logError((String)"Error al copiar archivos de datos.", (String)"ec.gob.sri.dimm.data", (Exception)e);
        }
    }

    private static void copiarArchivos(InputStream is, File f2) {
        FileOutputStream out = null;
        try {
            try {
                int len;
                out = new FileOutputStream(f2);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException ioe) {
                PluginLogger.logError((String)"Error al copiar archivos.", (String)"ec.gob.sri.dimm.data", (Exception)ioe);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    PluginLogger.logError((String)"Error al copiar archivos.", (String)"ec.gob.sri.dimm.data", (Exception)e);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                PluginLogger.logError((String)"Error al copiar archivos.", (String)"ec.gob.sri.dimm.data", (Exception)e);
            }
        }
    }

    public static InputStream loadStream(String filePath) throws IOException {
        InputStream is = Util.class.getResourceAsStream(filePath);
        if (is == null) {
            PluginLogger.logError((String)("Util--> InputStream():: URL:" + is + ", Path Archivo:" + filePath), (String)"ec.gob.sri.dimm.data");
        }
        return is;
    }
}

